/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CrossRun {
    private static final List<String> messages = Collections.synchronizedList(new ArrayList());
    private static volatile boolean failed = false;

    private static void error(String string) {
        System.out.println("ERROR: " + string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--")) continue;
            n = i;
            break;
        }
        if (n == -1) {
            CrossRun.error("Expected exactly one '--' as separator for the two process command lines.");
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray2.length);
        String[] stringArray3 = new String[stringArray.length - n - 1];
        System.arraycopy(stringArray, n + 1, stringArray3, 0, stringArray3.length);
        long l = System.currentTimeMillis();
        try {
            CrossRun.runProcesses(stringArray2, stringArray3);
        }
        catch (IOException iOException) {
            CrossRun.error(iOException.getMessage());
        }
        System.out.println("Completed in " + (System.currentTimeMillis() - l) + " ms.");
    }

    private static void runProcesses(String[] stringArray, String[] stringArray2) throws IOException {
        Process process = new ProcessBuilder(stringArray).start();
        Process process2 = new ProcessBuilder(stringArray2).start();
        Thread thread = new Thread(new StreamProxyRunner("process1", "process2", process.getInputStream(), process2.getOutputStream()));
        Thread thread2 = new Thread(new StreamProxyRunner("process2", "process1", process2.getInputStream(), process.getOutputStream()));
        thread.start();
        thread2.start();
        int n = -1;
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        int n2 = -1;
        try {
            n2 = process2.waitFor();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        try {
            thread2.join();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        if (n != 0) {
            messages.add("The process 1 returned with exit code " + n + ".");
        }
        if (n2 != 0) {
            messages.add("The process 2 returned with exit code " + n2 + ".");
        }
        for (String string : messages) {
            System.out.println("* " + string);
        }
        if (failed) {
            System.exit(1);
        }
    }

    private static final class StreamProxyRunner
    implements Runnable {
        private final String processName1;
        private final String processName2;
        private final InputStream inputStream;
        private final OutputStream outputStream;

        private StreamProxyRunner(String string, String string2, InputStream inputStream, OutputStream outputStream) {
            this.processName1 = string;
            this.processName2 = string2;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            byte[] byArray = new byte[65536];
            while (true) {
                int n;
                try {
                    n = this.inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    messages.add("Unexpected exception " + iOException.getClass().getSimpleName() + " while reading from the output of the " + this.processName1 + " process: " + iOException.getMessage());
                    failed = true;
                    break;
                }
                if (n < 0) break;
                try {
                    this.outputStream.write(byArray, 0, n);
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    messages.add("Unexpected exception " + iOException.getClass().getSimpleName() + " while writing to the input of the " + this.processName2 + " process: " + iOException.getMessage());
                    failed = true;
                    break;
                }
            }
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

