/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;
    private TermAttribute termAtt;

    public LengthFilter(TokenStream in, int min, int max) {
        super(in);
        this.min = min;
        this.max = max;
        this.termAtt = this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            int len = this.termAtt.termLength();
            if (len < this.min || len > this.max) continue;
            return true;
        }
        return false;
    }
}

